# N624 Downloader

> [!IMPORTANT]
> **このプロジェクトは一部AIを使用して作成しています**

このツールは、URLを入力することで動画や音声をダウンロードするバッチスクリプトです。

## 動作環境・依存関係

本ツールは以下の環境・依存関係で動作します：

- **対応OS**：Windows 10 / 11（※他OSは未サポート）
- **インターネット接続**：必要（初回実行時およびアップデート時に使用）
- **PowerShell**：Windows標準搭載（ダウンロード処理に使用）
- **yt-dlp**：YouTubeなどの動画サイトからダウンロードするためのツール
- **FFmpeg**：音声・動画の結合処理に必要
- **7zr.exe（7-Zip）**：FFmpegの圧縮ファイルを展開するために使用

## インストール方法
1. [Release](https://github.com/n624-dev/N624-Downloader/releases/latest)からZIPファイルをダウンロードします。
2. ZIPを右クリックして「すべて展開」を選び、任意の場所に展開してください。
3. `install.bat`を実行してください。
4. 自動的にすべてのファイルがダウンロードされます。
> [!WARNING]
> install.batやupdate.batがIDP.HERU.BD15と検知される場合があります。
> 心配な方はダウンロードして展開した後部分スキャン等でウイルスをスキャンしてください。

## 使用方法
> [!NOTE]
> 使用する前にupdate.batを実行することを推奨します。

1. `N624-Downloader.exe` をダブルクリック。
2. 動画のURLを入力してダウンロード開始を押す。
3. 自動で最高品質の動画と音声を結合してMP4形式で保存します。

## 更新

- `update.bat` を実行することで yt-dlp や FFmpeg を更新できます。

> [!NOTE]
> v0.2から関係するすべてのアプリケーションを更新できるようになりました。
> N624-Downloaderやupdate.bat、7zr.exeなど関係するものはすべて自動的にアップデートされます。

## ライセンス
このパッケージには、以下のオープンソースソフトウェアが含まれています。

---

■ 7-Zip（7zr.exe）
ライセンス: GNU LGPL v2.1
公式サイト: https://www.7-zip.org/

---

■ FFmpeg（ffmpeg.exe, ffprobe.exe, ffplay.exe）
ライセンス：GNU General Public License version 3（GPLv3）
取得元：https://www.gyan.dev/ffmpeg/builds/

このバイナリは、gyan.dev にて配布されている「essentials」ビルドです。
再配布にあたり、GPLv3のライセンス条件に従い、ソースコードの入手手段を以下に明記します。

ソースコードのダウンロードURL：
[https://www.gyan.dev/ffmpeg/builds/ffmpeg-git-full.7z](https://www.gyan.dev/ffmpeg/builds/ffmpeg-release-essentials.7z)

詳細なライセンス内容は [LICENSES/ffmpeg-GPL.txt](/LICENSES/ffmpeg-GPL.txt) をご参照ください。

---

■ yt-dlp（yt-dlp.exe）
ライセンス: The Unlicense（パブリックドメイン相当）
公式サイト: https://github.com/yt-dlp/yt-dlp

---

本パッケージは、これらのソフトウェアを公式配布元から取得し、改変せずにそのまま再配布しています。

詳細なライセンス内容については、同梱の「LICENSES」フォルダをご覧ください。

ご利用にあたっては、各ソフトウェアのライセンスに従ってください。

【注意事項】
- このビルドには、GPLライセンス対象のコンポーネントが含まれています。
- 商用利用の場合は、GPLライセンスの条件を十分に理解し遵守してください。
- このパッケージは公式のFFmpegプロジェクトとは無関係であり、gyan.devによる非公式ビルドを含みます。
- ソフトウェアの使用・再配布は自己責任でお願いします。
